clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

h  = [-1; .1];


% x0 = [-1;1];

x0 = [6; 3];



%% Algorithm



alpha_start = 0.99999999;
beta = 0.8;
% grad descent
% [x_final,data,k] = Gradient_Descent(@(x)(objective(x,Q,h)),Q,h,x0,alpha_start,beta);
[x_final,data,k] = Newton_unconstr(@(x)(objective(x,Q,h)),Q,h,x0,alpha_start,beta);

fprintf('Solution\n')
disp([x_final])
[f,g,H] = objective(x_final,Q,h);
fprintf('Final GAP: %.4e \n',norm(g))
%% Plotting




% Plot the QP
figure(1),clf, hold on, box on
% obj = @(x,y) 0.5*[x;y]'*Q*[x;y] + h'*[x;y];
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
% obj = @(x,y) x+y-log(x)-log(y);
fcontour(obj,'--','LineWidth',2)
colorbar

% Plot the optimum 
plot(x_final(1),x_final(2),"pentagram",'MarkerSize',10,'MarkerFaceColor','b')


% Plot the iterates and search directions

for i= 1:k+1
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    quiver(data.x(1,i),data.x(2,i),+data.d(1,i),+data.d(2,i),0)
    pause(0.1)
end




